<?php
// redirect.php universal

// lokasi data.json di domain utama
$mainDataUrl = "https://short.hibernasi.site/data/data.json";

// baca kode dari URL
$code = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), "/");

if ($code === "" || strlen($code) < 3) {
    http_response_code(404);
    echo "Not Found";
    exit;
}

// ambil data dari server utama
$dataJson = @file_get_contents($mainDataUrl);
if ($dataJson === false) {
    http_response_code(500);
    echo "Gagal mengambil data.";
    exit;
}

$data = json_decode($dataJson, true);
if (!is_array($data)) {
    http_response_code(500);
    echo "Data tidak valid.";
    exit;
}

// cek apakah kode ada
if (!isset($data[$code])) {
    http_response_code(404);
    echo "Shortlink tidak ditemukan.";
    exit;
}

// ambil links
$links = $data[$code]['links'] ?? [];
if (empty($links)) {
    http_response_code(404);
    echo "Link tujuan tidak ada.";
    exit;
}

// kalau hanya 1 link → langsung redirect
if (count($links) === 1) {
    header("Location: " . $links[0]);
    exit;
}

// kalau multi link → tampilkan pilihan
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($data[$code]['title'] ?? "Pilih Link") ?></title>
  <meta name="description" content="<?= htmlspecialchars($data[$code]['description'] ?? "") ?>">
  <?php if (!empty($data[$code]['og_image'])): ?>
    <meta property="og:image" content="<?= htmlspecialchars($data[$code]['og_image']) ?>">
  <?php endif; ?>
  <style>
    body { font-family: Arial, sans-serif; text-align: center; margin: 50px; }
    .link-box { margin: 15px; padding: 15px; border: 1px solid #ddd; border-radius: 8px; display: inline-block; width: 250px; }
    a { text-decoration: none; color: #007BFF; font-weight: bold; }
  </style>
</head>
<body>
  <h2><?= htmlspecialchars($data[$code]['title'] ?? "Pilih Link Tujuan") ?></h2>
  <p><?= htmlspecialchars($data[$code]['description'] ?? "") ?></p>
  <?php foreach ($links as $link): ?>
    <div class="link-box">
      <a href="<?= htmlspecialchars($link) ?>" target="_blank"><?= htmlspecialchars($link) ?></a>
    </div>
  <?php endforeach; ?>
</body>
</html>
